<?php
include 'config.php';

$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
$topic_id = isset($_GET['topic_id']) ? intval($_GET['topic_id']) : 0;

$user_details_query = "
SELECT 
    u.email, 
    c.category_name, 
    t.topic_name, 
    q.question_text, 
    o.option_text AS user_answer,
    o2.option_text AS correct_answer,
    (CASE WHEN o.option_id = o2.option_id THEN 1 ELSE 0 END) AS is_correct
FROM 
    responses r
JOIN 
    users u ON r.user_id = u.user_id
JOIN 
    questions q ON r.question_id = q.question_id
JOIN 
    options o ON r.option_id = o.option_id
JOIN 
    options o2 ON q.question_id = o2.question_id AND o2.is_correct = 1
JOIN 
    topics t ON q.topic_id = t.topic_id
JOIN 
    categories c ON t.category_id = c.category_id
WHERE 
    r.user_id = $user_id AND q.topic_id = $topic_id";

$user_details_result = $conn->query($user_details_query);
$user_details = [];
while ($row = $user_details_result->fetch_assoc()) {
    $user_details[] = $row;
}
if (empty($user_details)) {
    die("No results found for this user and topic.");
}

$email = $user_details[0]['email'];
$topic_name = $user_details[0]['topic_name'];

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>User Results</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/css/bootstrap.min.css">
    <link href="css/app.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
    .badge-circle {
        display: inline-block;
        width: 2rem;
        height: 2rem;
        border-radius: 50%;
        line-height: 2rem;
        text-align: center;
        padding: 0;
    }
</style>
</head>
<body>
    <div class="wrapper">
    <nav id="sidebar" class="sidebar js-sidebar">
            <div class="sidebar-content js-simplebar">
                <a class="sidebar-brand" href="index.php">
                    <span class="align-middle">Kijani Admin</span>
                </a>
                <ul class="sidebar-nav">
                    <li class="sidebar-header">Pages</li>
                    <li class="sidebar-item ">
                        <a class="sidebar-link" href="index.php">
                            <i class="align-middle" data-feather="sliders"></i>
                            <span class="align-middle">Dashboard</span>
                        </a>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link" href="create_questions.php">
                            <i class="align-middle" data-feather="book"></i>
                            <span class="align-middle">create questions</span>
                        </a>
                    </li>
                    <li class="sidebar-item active">
                        <a class="sidebar-link" href="view_results.php">
                            <i class="align-middle" data-feather="book"></i>
                            <span class="align-middle">view quiz results</span>
                        </a>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link" href="edit_questions.php">
                            <i class="align-middle" data-feather="book"></i>
                            <span class="align-middle">Edit Quiz</span>
                        </a>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link" href="users.php">
                            <i class="align-middle" data-feather="user"></i>
                            <span class="align-middle">Users</span>
                        </a>
                    </li>
                    <li class="sidebar-item  ">
                        <a class="sidebar-link" href="bulk_upload.php">
                            <i class="align-middle" data-feather="book"></i>
                            <span class="align-middle">Bulk upload</span>
                        </a>
                    </li>
                </ul>
            </div>
        </nav>
        <div class="main">
        <nav class="navbar navbar-expand navbar-light navbar-bg">
                <a class="sidebar-toggle js-sidebar-toggle">
                    <i class="hamburger align-self-center"></i>
                </a>
                <div class="navbar-collapse collapse">
                    <ul class="navbar-nav navbar-align">
                        <li class="nav-item dropdown">             
                            </a>
                            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end py-0" aria-labelledby="alertsDropdown">
                                 
                                <div class="list-group">
                                    <a href="#" class="list-group-item">
                                        <div class="row g-0 align-items-center">
                                            <div class="col-2">
                                                <i class="text-danger" data-feather="alert-circle"></i>
                                          </div>                              
                                        </div>
                                    </a>
                                    <a href="#" class="list-group-item">
                                        <div class="row g-0 align-items-center">
                                            <div class="col-2">
                                                <i class="text-warning" data-feather="bell"></i>
                                            </div>                                
                                        </div>
                                    </a>
                                    <a href="#" class="list-group-item">
                                        <div class="row g-0 align-items-center">
                                            <div class="col-2">
                                                <i class="text-primary" data-feather="home"></i>
                                            </div>                                         
                                        </div>
                                    </a>
                                    <a href="#" class="list-group-item">
                                        <div class="row g-0 align-items-center">
                                            <div class="col-2">
                                                <i class="text-success" data-feather="user-plus"></i>
                                            </div>
                                            
                                        </div>
                                    </a>
                                </div>                  
                            </div>
                        </li>
                        <li class="nav-item dropdown">                    
                            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end py-0" aria-labelledby="messagesDropdown">
                                <div class="dropdown-menu-header">
                                     
                                </div>
                                <div class="list-group">
                                    <a href="#" class="list-group-item">
                                        <div class="row g-0 align-items-center">
                                            <div class="col-2">
                                                <img src="img/avatars/avatar-5.jpg" class="avatar img-fluid rounded-circle" alt="Vanessa Tucker">
                                            </div>                                         
                                        </div>
                                    </a>
                                    <a href="#" class="list-group-item">
                                        <div class="row g-0 align-items-center">
                                            <div class="col-2">
                                                <img src="img/avatars/avatar-2.jpg" class="avatar img-fluid rounded-circle" alt="William Harris">
                                            </div>            
                                        </div>
                                    </a>
                                    <a href="#" class="list-group-item">
                                        <div class="row g-0 align-items-center">
                                            <div class="col-2">
                                                <img src="img/avatars/avatar-4.jpg" class="avatar img-fluid rounded-circle" alt="Christina Mason">
                                            </div>
                                             
                                        </div>
                                    </a>
                                    <a href="#" class="list-group-item">
                                        <div class="row g-0 align-items-center">
                                            <div class="col-2">
                                                <img src="img/avatars/avatar-3.jpg" class="avatar img-fluid rounded-circle" alt="Sharon Lessman">
                                            </div>
                                             
                                        </div>
                                    </a>
                                </div>
                                 
                            </div>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle d-none d-sm-inline-block" href="#" data-bs-toggle="dropdown">
                                <img src="img/avatars/avatar.jpg" class="avatar img-fluid rounded me-1" alt="Charles Hall" /> 
                            </a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <a class="dropdown-item" href="pages-profile.html"><i class="align-middle me-1" data-feather="user"></i> Profile</a>
                                <a class="dropdown-item" href="#"><i class="align-middle me-1" data-feather="pie-chart"></i> Analytics</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="index.php"><i class="align-middle me-1" data-feather="settings"></i> Settings & Privacy</a>
                                <a class="dropdown-item" href="#"><i class="align-middle me-1" data-feather="help-circle"></i> Help Center</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="#">Log out</a>
                            </div>
                        </li>
                    </ul>
                </div>
            </nav>
            <main class="content">
                <div class="container-fluid p-0">
                    <h1 class="h3 mb-3">user results</h1>

                    <div class="row">
                        <div class="col-12">
                             
                            <div class="card">
                                <div class="card-header">
                                <h5 class="card-title">Results for <?php echo htmlspecialchars($email); ?></h5>
                                <h4 class="card-title"> topic:  <?php echo htmlspecialchars($topic_name);?></h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-hover table-striped">
                                        <thead>
                                            <tr>
                                        <thead>
                                            <tr>
                                            
                    
                    <th>Question</th>
                    <th>User Answer</th>
                    <th>Correct Answer</th>
                    <th>Is Correct</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                <?php foreach ($user_details as $detail): ?>
                    <tr>
                    
                      
                        <td><?= htmlspecialchars($detail['question_text']); ?></td>
                        <td><?= htmlspecialchars($detail['user_answer']); ?></td>
                        <td><?= htmlspecialchars($detail['correct_answer']); ?></td>
                        <td>
    <?= $detail['is_correct'] ? '<span class="badge badge-success rounded-circle"><i class="fas fa-check"></i></span>' : '<span class="badge badge-danger rounded-circle"><i class="fas fa-times"></i></span>'; ?>
</td>


                    </tr>
                <?php endforeach; ?>
            </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>

            <footer class="footer">
                <!-- Footer content here -->
            </footer>
        </div>
    </div>

    <script src="js/app.js"></script>
     
</body>

</html>
